/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel;

import io.github.thecsdev.betterstats.client.gui.panel.BSPanel;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel_StatisticsFilters;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel_StatisticsMenuBar;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel_BalancedDiet;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel_General;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel_Items;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel_Mobs;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel_MonsterHunter;
import io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.client.gui.widget.BSScrollBarWidget;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_3469;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class BSPanel_Statistics
extends BSPanel {
    protected final BetterStatsScreen betterStats;
    protected BSPanel_StatisticsMenuBar panel_menuBar;
    protected BSPanel_StatisticsFilters panel_leftMenu;
    protected BSPanel panel_rightMenu;
    protected BSStatPanel panel_stats;
    protected BSScrollBarWidget scroll_left;
    protected Consumer<Integer> __handler0;

    public BSPanel_Statistics(BetterStatsScreen bss) {
        super(bss.getTpeX(), bss.getTpeY(), bss.getTpeWidth(), bss.getTpeHeight());
        this.betterStats = Objects.requireNonNull(bss, "bss must not be null.");
        this.setVisible(false);
    }

    public boolean canBeAddedTo(TParentElement parent) {
        return parent == this.betterStats;
    }

    @Nullable
    public BSStatPanel getCurrentStatPanel() {
        return this.panel_stats;
    }

    public void init() {
        int mcpX = 10;
        int mcpY = 10;
        int mcpW = (int)((float)this.getTpeWidth() / 3.5f);
        int mcpH = this.getTpeHeight() - 20;
        int scpX = mcpX + mcpW + 10;
        int scpY = mcpY;
        int scpW = this.getTpeWidth() - scpX - 10;
        int scpH = mcpH;
        this.panel_menuBar = new BSPanel_StatisticsMenuBar(mcpX, 0, Math.abs(mcpX - (scpX + scpW)), 15);
        this.panel_leftMenu = new BSPanel_StatisticsFilters(mcpX, mcpY += 10, mcpW, mcpH -= 10);
        this.panel_rightMenu = new BSPanel(scpX + 4, scpY += 10, scpW - 4, scpH -= 10);
        this.panel_stats = null;
        this.addTChild((TElement)this.panel_menuBar);
        this.addTChild((TElement)this.panel_leftMenu);
        this.addTChild((TElement)this.panel_rightMenu);
        this.scroll_left = new BSScrollBarWidget(this.panel_leftMenu.getTpeEndX() - 1, this.panel_leftMenu.getTpeY(), 8, this.panel_leftMenu.getTpeHeight(), this.panel_leftMenu);
        this.addTChild((TElement)this.scroll_left);
        this.init_menuBar();
        this.init_stats();
        this.init_leftMenu();
    }

    protected void init_menuBar() {
        if (this.panel_menuBar == null) {
            return;
        }
        this.panel_menuBar.clearTChildren();
        this.panel_menuBar.init(this.betterStats);
    }

    public void init_leftMenu() {
        if (this.panel_leftMenu == null) {
            return;
        }
        this.panel_leftMenu.clearTChildren();
        this.panel_leftMenu.init(this.betterStats);
    }

    public void init_stats() {
        if (this.panel_rightMenu == null) {
            return;
        }
        this.panel_rightMenu.clearTChildren();
        class_3469 bssSh = this.betterStats.getStatHandler();
        Predicate<StatUtils.StatUtilsStat> bssSp = this.betterStats.getStatPredicate();
        BSStatPanel sPanel = null;
        switch (this.betterStats.filter_currentTab) {
            case General: {
                sPanel = new BSStatPanel_General(this.panel_rightMenu);
                sPanel.init(this.betterStats, bssSh, bssSp);
                break;
            }
            case Items: {
                sPanel = new BSStatPanel_Items(this.panel_rightMenu);
                sPanel.init(this.betterStats, bssSh, bssSp);
                break;
            }
            case Entities: {
                sPanel = new BSStatPanel_Mobs(this.panel_rightMenu);
                sPanel.init(this.betterStats, bssSh, bssSp);
                break;
            }
            case MonstersHunted: {
                sPanel = new BSStatPanel_MonsterHunter(this.panel_rightMenu);
                sPanel.init(this.betterStats, bssSh, this.betterStats.getStatPredicate_searchFilter());
                break;
            }
            case FoodStuffs: {
                sPanel = new BSStatPanel_BalancedDiet(this.panel_rightMenu);
                sPanel.init(this.betterStats, bssSh, this.betterStats.getStatPredicate_searchFilter());
                break;
            }
            default: {
                this.panel_rightMenu.clearTChildren();
            }
        }
        if (sPanel != null) {
            BSScrollBarWidget scroll = sPanel.getVerticalScrollBar();
            scroll.setValue(this.betterStats.filter_statsScroll);
            this.__handler0 = (Consumer)sPanel.getEvents().SCROLL_V.addWeakEventHandler(dY -> {
                this.betterStats.filter_statsScroll = scroll.getValue();
            });
        }
        this.panel_stats = sPanel;
    }

    @Override
    public void postRender(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
    }
}

